/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ActionHandler;
import jclass.chart.JCAxis;
import jclass.chart.JCChartArea;

class ZoomHandler
extends ActionHandler {
    Point first;
    Point last;

    ZoomHandler(JCChartArea jCChartArea) {
        super(jCChartArea);
    }

    void start(int n, int n2) {
        this.first = new Point(n, n2);
        this.last = null;
    }

    void animate(int n, int n2) {
        if (this.first == null) {
            return;
        }
        if (this.last == null) {
            this.last = new Point(n, n2);
            this.parent.drawRubberBand(this.last, this.first);
            return;
        }
        this.parent.drawRubberBand(this.last, this.first);
        this.last.x = n;
        this.last.y = n2;
        this.parent.drawRubberBand(this.last, this.first);
    }

    void reanimate(int n, int n2) {
        this.last = new Point(n, n2);
        this.parent.drawRubberBand(this.last, this.first);
    }

    void end(int n, int n2) {
        double d;
        Rectangle rectangle = null;
        JCAxis jCAxis = null;
        JCAxis jCAxis2 = null;
        boolean bl = false;
        this.parent.drawRubberBand(this.last, this.first);
        rectangle = this.parent.getDrawingArea();
        if (this.parent.horizActionAxis.getIsVertical() && !this.parent.vertActionAxis.getIsVertical()) {
            jCAxis = this.parent.vertActionAxis;
            jCAxis2 = this.parent.horizActionAxis;
        } else if (!this.parent.horizActionAxis.getIsVertical() && this.parent.vertActionAxis.getIsVertical()) {
            jCAxis = this.parent.horizActionAxis;
            jCAxis2 = this.parent.vertActionAxis;
        } else {
            System.out.println("ZoomHandler: Wierd axes!");
        }
        int n3 = 7;
        if (Math.abs(n - this.first.x) + Math.abs(n2 - this.first.y) < n3) {
            int n4 = 10;
            this.first.x = Math.max(n - n4, rectangle.x);
            n = Math.min(n + n4, rectangle.x + rectangle.width);
            this.first.y = Math.max(n2 - n4, rectangle.y);
            n2 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        }
        if (jCAxis != null && jCAxis.isEditable) {
            double d2 = jCAxis.toData(this.first.x - rectangle.x);
            d = jCAxis.toData(n - rectangle.x);
            this.parent.chart.zoom(d2, d, jCAxis, false);
            bl = true;
        }
        if (jCAxis2 != null && jCAxis2.isEditable) {
            double d3 = jCAxis2.toData(this.first.y - rectangle.y);
            d = jCAxis2.toData(n2 - rectangle.y);
            this.parent.chart.zoom(d3, d, jCAxis2, false);
            bl = true;
        }
        if (bl) {
            this.parent.setChanged(true);
        }
    }
}

